<?php

function qoxag_import_files() {
	$demo_content_installer	 = QOXAG_REMOTE_CONTENT;
	return array(
	  array(
		'import_file_name'           => 'Default Home (1-6)',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/default/default.xml',
		'import_customizer_file_url' => $demo_content_installer . '/default/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/default/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/default/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL,
	  ),
	  array(
		'import_file_name'           => 'RTL Demo',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/rtl/main.xml',
		'import_customizer_file_url' => $demo_content_installer . '/rtl/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/rtl/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/rtl/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL . 'rtl'
	  ),
	  array(
		'import_file_name'           => 'Gadget Demo',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/gadget/main.xml',
		'import_customizer_file_url' => $demo_content_installer . '/gadget/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/gadget/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/gadget/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL . 'gadget'
	  ),
	  array(
		'import_file_name'           => 'Food Review',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/food-review/main.xml',
		'import_customizer_file_url' => $demo_content_installer . '/food-review/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/food-review/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/food-review/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL . 'food-review'
	  ),
	  array(
		'import_file_name'           => 'Newspaper Demo',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/newspaper/main.xml',
		'import_customizer_file_url' => $demo_content_installer . '/newspaper/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/newspaper/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/newspaper/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL . 'newspaper'
	  ),
	  array(
		'import_file_name'           => 'Personal Blog Home (1-2)',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/personal/main.xml',
		'import_customizer_file_url' => $demo_content_installer . '/personal/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/personal/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/personal/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL . 'personal-blog'
	  ),
	  array(
		'import_file_name'           => 'Gutenberg Demo',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/gutenberg/main.xml',
		'import_customizer_file_url' => $demo_content_installer . '/gutenberg/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/gutenberg/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/gutenberg/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL . 'gutenberg'
	  ),
	  array(
		'import_file_name'           => 'WooCommerce Demo',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/woocommerce/main.xml',
		'import_customizer_file_url' => $demo_content_installer . '/woocommerce/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/woocommerce/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/woocommerce/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL . 'woo-commerce'
	  ),
	  array(
		'import_file_name'           => 'Travel Demo',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/travel/main.xml',
		'import_customizer_file_url' => $demo_content_installer . '/travel/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/travel/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/travel/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL . 'travel'
	  ),
	  array(
		'import_file_name'           => 'Health Magazine',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/health-magazine/main.xml',
		'import_customizer_file_url' => $demo_content_installer . '/health-magazine/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/health-magazine/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/health-magazine/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL . 'health-magazine'
	  ),
	  array(
		'import_file_name'           => 'Magazine',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/magazine/main.xml',
		'import_customizer_file_url' => $demo_content_installer . '/magazine/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/magazine/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/magazine/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL . 'magazine'
	  ),
	  array(
		'import_file_name'           => 'Sports',
		'categories'                 => array( 'Multipage' ),
		'import_file_url'            => $demo_content_installer . '/sports/main.xml',
		'import_customizer_file_url' => $demo_content_installer . '/sports/customizer.dat',
		'import_widget_file_url'     => $demo_content_installer . '/sports/widgets.wie',
		'import_preview_image_url'   => $demo_content_installer . '/sports/screenshot.png',
		'preview_url'                => QOXAG_LIVE_URL . 'sports'
	  )
	);
}
add_filter( 'pt-ocdi/import_files', 'qoxag_import_files' );

function qoxag_after_import( $selected_import ) {

	$slider_array = array(
		"Default Home (1-6)" => [
			"slug" => "Home",
		],
		"RTL Demo" => [
			"slug" => "Home",
		],
		"Gadget Demo" => [
			"slug" => "Home",
		],
		"Food Review" => [
			"slug" => "Home",
		],
		"Personal Blog" => [
			"slug" => "Home",
		],
		"Guttenburg Demo" => [
			"slug" => "Home",
		],
		"WooCommerce Demo" => [
			"slug" => "Home",
		],
		"Travel Demo" => [
			"slug" => "Home",
		],
		"Health Magazine" => [
			"slug" => "Home",
		],
		"Magazine" => [
			"slug" => "Home",
		],
	);
	if( is_array( $slider_array ) ){
		foreach ($slider_array as $i => $values) {
			if ( $i === $selected_import['import_file_name'] ) {
				foreach ($values as $key => $value) {
					//Set Front page
					$page = get_page_by_title( $values['slug'] );
					if ( isset( $page->ID ) ) {
						update_option( 'page_on_front', $page->ID );
						update_option( 'show_on_front', 'page' );
					}
				}
			}
		}
	}
}
add_action( 'pt-ocdi/after_import', 'qoxag_after_import' );


function demo_license_content() {
	?>
	<div class="license-wrap">
		<h2 class="license-title"><?php esc_html_e( 'Please Activate Your License', 'qoxag' ); ?></h2>
		<div class="license-desc">
			<div class="notice-icon">
				<svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M8.27148 5.6001V9.80009" stroke="#FF7129" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
					<path d="M15.536 6.26402V11.736C15.536 12.632 15.056 13.464 14.28 13.92L9.52801 16.664C8.75201 17.112 7.792 17.112 7.008 16.664L2.256 13.92C1.48 13.472 1 12.64 1 11.736V6.26402C1 5.36802 1.48 4.53599 2.256 4.07999L7.008 1.336C7.784 0.888 8.74401 0.888 9.52801 1.336L14.28 4.07999C15.056 4.53599 15.536 5.36002 15.536 6.26402Z" stroke="#FF7129" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
					<path d="M8.27148 12.3599V12.4399" stroke="#FF7129" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
				</svg>
			</div>
			<p>
			<?php 
				echo qoxag_kses('In order to get regular update, support and demo content, you must activate the theme license. Please  <a href="'. admin_url('themes.php?page=license') .'">Goto License Page</a> and activate the theme license as soon as possible.	','qoxag');
			?>
			</p>
		</div>
	</div>
	<?php
}

function set_license_menu() {
	if ( theme_is_valid_license() ) {
		return;
	}

	remove_submenu_page('themes.php', 'demo-content');
	$page = isset( $_GET['page'] ) ? sanitize_text_field( $_GET['page'] ) : '';

	if ( 'one-click-demo-import' === $page ) {
		// wp_die('Sorry, you are not allowed to access this page', '');
		wp_redirect(admin_url("themes.php?page=license"));
	}

	add_submenu_page(
		'themes.php',
		'Demo Content Install',
		'Demo Content Install',
		'manage_options',
		'demo-content',
		'demo_license_content'
	);
}

add_action('admin_menu', 'set_license_menu', 999);